package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.DataTypeDTO;
import gov.va.genisis2.model.DataType;

/**
 * This class is used to convert DataTypeDTO to DataType entity and vice-versa.
 * 
 *
 */
@Component
public class DataTypeConverter implements Converter<DataType, DataTypeDTO> {

	@Override
	public DataTypeDTO convert(DataType dataType) {
		DataTypeDTO dataTypeDto = new DataTypeDTO();

		dataTypeDto.setId(dataType.getId());
		dataTypeDto.setDescription(dataType.getDescription());

		return dataTypeDto;
	}

	public DataType convert(DataTypeDTO dataTypeDto) {
		DataType dataType = new DataType();

		dataType.setId(dataTypeDto.getId());
		dataType.setDescription(dataTypeDto.getDescription());

		return dataType;
	}

	public List<DataTypeDTO> convertDataTypes(List<DataType> dataTypes) {
		List<DataTypeDTO> dataTypesDtos = null;
		if (!dataTypes.isEmpty()) {
			dataTypesDtos = new ArrayList<>();
			for (DataType dataType : dataTypes) {
				dataTypesDtos.add(convert(dataType));
			}
		}

		return dataTypesDtos;
	}
}
